﻿function hideDependentFields(element) {
    var action = 'show',
        currentElement = element,
        siblingElements = currentElement.up('.scEditorFieldMarker').nextSiblings();

    // for checkbox type elements check if unchecked
    if (element.type === 'checkbox' && !element.checked) {
        action = 'hide';
    }

    //prettier-ignore
    siblingElements.each(childElement => {
        var checkbox = childElement.querySelector('.scContentControlCheckbox');
        if (checkbox) {
            if (action === 'hide') {
                checkbox.setAttribute('disabled', true);
                checkbox.checked = false;
            } else {
                checkbox.removeAttribute('disabled');
                checkbox.checked = checkbox.defaultChecked;
            }
        }
    });
}

// add script to be called when content editor is loaded
document.observe('sc:contenteditorupdated', function () {
    $$('.hide-dependent-fields').each(function (element) {
        hideDependentFields(element);
    });
});
